#!/bin/sh

function set_gpio_out(){
	dir=`pwd`
	cd /sys/class/gpio
	echo "set gpio $1"
	if [ ! -d gpio$1 ];then
		echo $1 > export
	fi
	cd gpio$1
	echo out > direction
	echo $2 > value
	cd $dir
}

function set_gpio_in(){
	dir=`pwd`
	cd /sys/class/gpio
	echo "set gpio $1"
	if [ ! -d gpio$1 ];then
		echo $1 > export
	fi
	cd gpio$1
	echo in > direction
	echo $2 > value
	cd $dir
}

function set_led_blink() {  # $1=led, $2=delay_on(ms), $3=delay_off(ms)
    dir=`pwd`
    if [ -e /sys/class/leds/led$1 ]; then
        echo "timer" > /sys/class/leds/led$1/trigger
        echo $2 > /sys/class/leds/led$1/delay_on
        echo $3 > /sys/class/leds/led$1/delay_off
    fi
    cd $dir
}

function oled_show_reboot() {
    echo 0xae > /sys/class/graphics/fb1/on_spi
    lang=$(grep LANG_SET /opt/tersus/rtk.conf | sed 's/#.*//g' | sed 's/ //g' | awk '{split($0,array,"=")}END{print array[2]}')
    if [ "x$lang" = "x1" ]; then
        cat /opt/tersus/fb/rbt_cn.fb > /dev/fb1
    else
        cat /opt/tersus/fb/rbt_en.fb > /dev/fb1
    fi
    echo 0xaf > /sys/class/graphics/fb1/on_spi
}

function oled_show_upgrade() {
    echo 0xae > /sys/class/graphics/fb1/on_spi
    lang=$(grep LANG_SET /opt/tersus/rtk.conf | sed 's/#.*//g' | sed 's/ //g' | awk '{split($0,array,"=")}END{print array[2]}')
    if [ "x$lang" = "x1" ]; then
        cat /opt/tersus/fb/upd_cn.fb > /dev/fb1
    else
        cat /opt/tersus/fb/upd_en.fb > /dev/fb1
    fi
    echo 0xaf > /sys/class/graphics/fb1/on_spi
}

function oled_clear_screen() {
    dd if=/dev/zero of=/dev/fb1 bs=1k count=1
}

function begin_update() {
    #set led stat, display updating info on oled
    echo "Begin Updating..."
    oled_show_upgrade
    set_led_blink 0 500  0
    set_led_blink 1 500  0
    set_led_blink 2 500  0
    set_led_blink 3 500  0
    set_led_blink 4 500  0
    set_led_blink 5 500  0
}

function end_update() {
    #clear led stat, clear updating info on	 oled
    echo "End Updating..."
    oled_show_reboot
    set_led_blink 0 0  500
    set_led_blink 1 0  500
    set_led_blink 2 0  500
    set_led_blink 3 0  500
    set_led_blink 4 0  500
    set_led_blink 5 0  500
    sleep 1
    #oled_clear_screen
}
function udisk_check() {
    udisk=$(df | grep "/run/media/sd"  | awk '{split($0,array, " ")}END{print array[6]}')
    if [ "x$udisk" = "x" ]; then
        echo "No USB Disk."
        return -1
    fi

    if [ -f /update/update.log ]; then
        #lastupd=$( tail -n 1 /update/update.log )
		lastupd=$( cat /update/update.log  | grep '^TersusOscarUpdPack.*\.bin$' | tail -n 1 )
    fi
    if [ -d $udisk/OscarUpdate ]; then
		usbfile=$( ls $udisk/OscarUpdate  | grep '^TersusOscarUpdPack.*\.bin$' | tail -n 1 )
    fi
    if [ "x$usbfile" = "x" ]; then
		echo "No update package."
		return -1
	else
		tar -zxf ${udisk}/OscarUpdate/${usbfile} -C /update TersusOscarUpdPack/version.txt  
		if [ -e /update/TersusOscarUpdPack/version.txt ]; then
			usbupd=$( cat /update/TersusOscarUpdPack/version.txt )
			rm -rf /update/TersusOscarUpdPack
		fi
    fi
    if [ "x$lastupd" \< "x$usbupd" ]; then
		echo "Update from usb disk."
		cp  $udisk/OscarUpdate/$usbfile /update/
		sync; sync; sync; sync; sync
		echo 3 > /proc/sys/vm/drop_caches
		blockdev --flushbufs /dev/mmcblk1p1
    else
		echo "Alread updated.."
        return -1
	fi
    
}

function check_update() {
        exedir=$(pwd)
        if [ ! -d /update ]; then 
            mkdir /update
        fi
        udisk_check
        upd=$( ls -t /update  | grep '^TersusOscarUpdPack.*\.bin$' | head -n 1 )
        if [ "x$upd" = "x" ]; then
                echo "No update task."
                return -1
        fi
		echo "update system with $upd"
		cd /update
		if [ -s $upd  ]; then
			begin_update
			tempdir=TersusOscarUpdPack
			tar -zxf $upd
			if [ $?  -eq 0 ]; then
				sync; sync; sync
				cd  $tempdir
				chmod +x update.sh
				./update.sh
				if [ -e version.txt ]; then
					cat version.txt >> /update/update.log
				else
					echo "$upd" >> /update/update.log
				fi
				cd ..
			fi
			rm -rf /update/TersusOscar*
			sync; sync
			end_update
			reboot
		fi
        cd $exedir
}

check_update


