#!/bin/sh
if test -f u-boot.imx ; then
		flash_erase /dev/mtd0 0 0
        /bin/dd if=u-boot.imx of=/dev/mtd0 bs=1k seek=4
		/bin/dd if=qspi-header of=/dev/mtd0 bs=1k seek=1
fi

if test -f zImage ; then
		flash_erase /dev/mtd1 0 0
        /bin/dd if=zImage  of=/dev/mtd1 bs=1k seek=0
fi

if test -f imx6ull-neortk2.dtb ; then
        flash_erase /dev/mtd2 0 0
		/bin/dd if=imx6ull-neortk2.dtb of=/dev/mtd2 bs=1k seek=0
fi

killall watchdog rtkmain  webapp  > /dev/null  2>&1
sleep 3
mkdir -p /opt/tersus
mkdir -p /opt/tersus/log
mkdir -p /opt/tersus/font
mkdir -p /opt/tersus/audio
mkdir -p /opt/tersus
if [ ! -e /mnt/gnss ]; then
	mkdir -p /mnt/gnss
fi
cp libdr_default.so  /usr/lib/
cp libdr_tersus.so  /usr/lib/
if [ -e libOscarRTK.so ]; then
	cp libOscarRTK.so  /usr/lib/
fi
cp -R www  /var/
cp -R xml  /opt/tersus/
cp -R fb  /opt/tersus/
cp rtkmain webapp  watchdog /opt/tersus/
cp tersus.db /opt/tersus/
cp devinfo.ko /opt/tersus/ 
cp rtk.conf /opt/tersus
cp fstab /etc/fstab
cp check_update.sh  /opt/tersus/
cp rc.local /etc/init.d/rc.local
if [ -e gnssfw ]; then
	if [ -e /opt/tersus/gnssfw ]; then
		rm -rf /opt/tersus/gnssfw/*
	fi
	cp -r gnssfw  /opt/tersus
fi
chmod +x /opt/tersus/rtkmain 
chmod +x /opt/tersus/webapp 
chmod +x /opt/tersus/watchdog 
chmod +x /opt/tersus/check_update.sh

